/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.structurepanel;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class AddElementTool
extends Tool {
    private int type;
    private StructureListElement element;
    private JTable table;
    private StructureElement newElement;

    public AddElementTool(StructureListElement structureListElement, JTable jTable) {
        this.type = structureListElement.getDataControl().getAddableElements()[0];
        this.element = structureListElement;
        this.table = jTable;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (this.element.getDataControl().canAddElement(this.type)) {
            String string = this.element.getDataControl().getDefaultId(this.type);
            string.replaceAll(" ", "_");
            if (string != null && string.length() > 0 && Character.isDigit(string.charAt(0))) {
                string = "MH" + string;
            } else if (string == null || string.length() == 0) {
                string = "";
            }
            String string2 = string;
            int n = 0;
            while (!Controller.getInstance().isElementIdValid(string2, false)) {
                string2 = string + ++n;
            }
            if (this.element.getDataControl().addElement(this.type, string2)) {
                ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
                this.table.changeSelection(this.element.getChildCount() - 1, 0, false, false);
                this.newElement = this.element.getChild(this.element.getChildCount() - 1);
                return true;
            }
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "Add child";
    }

    @Override
    public boolean undoTool() {
        this.newElement.delete(false);
        Controller.getInstance().updateStructure();
        return true;
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public boolean redoTool() {
        return false;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

