/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class SetTrajectoryInitialNodeTool
extends Tool {
    private Trajectory trajectory;
    private TrajectoryDataControl trajectoryDataControl;
    private NodeDataControl nodeDataControl;
    private NodeDataControl oldInitialNodeDataControl;

    public SetTrajectoryInitialNodeTool(Trajectory trajectory, TrajectoryDataControl trajectoryDataControl, NodeDataControl nodeDataControl) {
        this.trajectory = trajectory;
        this.trajectoryDataControl = trajectoryDataControl;
        this.nodeDataControl = nodeDataControl;
        this.oldInitialNodeDataControl = trajectoryDataControl.getInitialNode();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.trajectory.getInitial() != null && this.trajectory.getInitial().getID().equals(this.nodeDataControl.getID())) {
            return false;
        }
        this.trajectory.setInitial(this.nodeDataControl.getID());
        if (this.trajectoryDataControl.initialNode != null) {
            this.trajectoryDataControl.initialNode.setInitial(false);
        }
        this.trajectoryDataControl.initialNode = this.nodeDataControl;
        this.trajectoryDataControl.initialNode.setInitial(true);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.trajectory.setInitial(this.nodeDataControl.getID());
        if (this.trajectoryDataControl.initialNode != null) {
            this.trajectoryDataControl.initialNode.setInitial(false);
        }
        this.trajectoryDataControl.initialNode = this.nodeDataControl;
        this.trajectoryDataControl.initialNode.setInitial(true);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.nodeDataControl.setInitial(false);
        this.trajectoryDataControl.initialNode = this.oldInitialNodeDataControl;
        if (this.trajectoryDataControl.initialNode != null) {
            this.trajectory.setInitial(this.trajectoryDataControl.getInitialNode().getID());
            this.trajectoryDataControl.initialNode.setInitial(true);
        } else {
            this.trajectory.setInitial("");
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

