/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class SetSideLengthTool
extends Tool {
    private float oldLength;
    private Trajectory.Side side;
    private float value;

    public SetSideLengthTool(Trajectory.Side side, Integer n) {
        this.side = side;
        this.value = n.intValue();
        this.oldLength = side.getLength();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof SetSideLengthTool) {
            SetSideLengthTool setSideLengthTool = (SetSideLengthTool)tool;
            if (setSideLengthTool.side != this.side) {
                return false;
            }
            this.value = setSideLengthTool.value;
            this.timeStamp = setSideLengthTool.timeStamp;
            return true;
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.side.setLenght(this.value);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.side.setLenght(this.value);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.side.setLenght(this.oldLength);
        Controller.getInstance().updatePanel();
        return true;
    }
}

