/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.HashMap;

public class SetNodeValuesTool
extends Tool {
    private int oldX;
    private int oldY;
    private float oldScale;
    private int newX;
    private int newY;
    private float newScale;
    private Trajectory.Node node;
    private Trajectory trajectory;
    private HashMap<String, Float> oldLengths;

    public SetNodeValuesTool(Trajectory.Node node, Trajectory trajectory, int n, int n2, float f) {
        this.newX = n;
        this.newY = n2;
        this.newScale = f;
        this.oldX = node.getX();
        this.oldY = node.getY();
        this.oldScale = node.getScale();
        this.node = node;
        this.trajectory = trajectory;
        this.oldLengths = new HashMap();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof SetNodeValuesTool) {
            SetNodeValuesTool setNodeValuesTool = (SetNodeValuesTool)tool;
            if (setNodeValuesTool.node != this.node) {
                return false;
            }
            this.newX = setNodeValuesTool.newX;
            this.newY = setNodeValuesTool.newY;
            this.newScale = setNodeValuesTool.newScale;
            this.timeStamp = setNodeValuesTool.timeStamp;
            return true;
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.node.setValues(this.newX, this.newY, this.newScale);
        if (this.newX != this.oldX || this.newY != this.oldY) {
            for (Trajectory.Side side : this.trajectory.getSides()) {
                if (!side.getIDEnd().equals(this.node.getID()) && !side.getIDStart().equals(this.node.getID())) continue;
                this.oldLengths.put(side.getIDStart() + ";" + side.getIDEnd(), Float.valueOf(side.getLength()));
                Trajectory.Node node = this.trajectory.getNodeForId(side.getIDStart());
                Trajectory.Node node2 = this.trajectory.getNodeForId(side.getIDEnd());
                double d = node.getX() - node2.getX();
                double d2 = node.getY() - node2.getY();
                side.setLenght((float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)));
                side.setRealLength((float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)));
            }
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        this.node.setValues(this.newX, this.newY, this.newScale);
        if (this.newX != this.oldX || this.newY != this.oldY) {
            for (Trajectory.Side side : this.trajectory.getSides()) {
                if (!side.getIDEnd().equals(this.node.getID()) && !side.getIDStart().equals(this.node.getID())) continue;
                Trajectory.Node node = this.trajectory.getNodeForId(side.getIDStart());
                Trajectory.Node node2 = this.trajectory.getNodeForId(side.getIDEnd());
                double d = node.getX() - node2.getX();
                double d2 = node.getY() - node2.getY();
                side.setLenght((float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)));
                side.setRealLength((float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)));
            }
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.node.setValues(this.oldX, this.oldY, this.oldScale);
        if (this.newX != this.oldX || this.newY != this.oldY) {
            for (Trajectory.Side side : this.trajectory.getSides()) {
                Object object;
                if (side.getIDEnd().equals(this.node.getID()) || side.getIDStart().equals(this.node.getID())) {
                    object = this.trajectory.getNodeForId(side.getIDStart());
                    Trajectory.Node node = this.trajectory.getNodeForId(side.getIDEnd());
                    double d = object.getX() - node.getX();
                    double d2 = object.getY() - node.getY();
                    side.setRealLength((float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)));
                }
                if ((object = this.oldLengths.get(side.getIDStart() + ";" + side.getIDEnd())) == null) continue;
                side.setLenght(((Float)object).floatValue());
            }
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

