/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import javax.swing.JTable;

public class MoveExitTool
extends Tool {
    private ExitsListDataControl dataControl;
    private JTable table;
    private boolean moveUp;
    private ExitDataControl element;
    private int position;

    public MoveExitTool(ExitsListDataControl exitsListDataControl, JTable jTable, boolean bl) {
        this.dataControl = exitsListDataControl;
        this.table = jTable;
        this.moveUp = bl;
        this.position = this.table.getSelectedRow();
        this.element = this.dataControl.getExits().get(this.position);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.action(this.moveUp);
        return true;
    }

    private void action(boolean bl) {
        if (!bl && this.dataControl.moveElementDown(this.element)) {
            this.table.getSelectionModel().setSelectionInterval(this.position + 1, this.position + 1);
            this.table.updateUI();
        }
        if (bl && this.dataControl.moveElementUp(this.element)) {
            this.table.getSelectionModel().setSelectionInterval(this.position - 1, this.position - 1);
            this.table.updateUI();
        }
        this.moveUp = !this.moveUp;
    }

    @Override
    public boolean redoTool() {
        this.action(this.moveUp);
        return true;
    }

    @Override
    public boolean undoTool() {
        this.action(this.moveUp);
        return true;
    }
}

