/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;

public class DuplicateExitTool
extends Tool {
    private ExitsListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private ExitDataControl newExit;
    private int selected;

    public DuplicateExitTool(ExitsListDataControl exitsListDataControl, IrregularAreaEditionPanel irregularAreaEditionPanel, int n) {
        this.dataControl = exitsListDataControl;
        this.iaep = irregularAreaEditionPanel;
        this.selected = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getExits().get(this.selected))) {
            this.newExit = this.dataControl.getLastExit();
            this.iaep.getScenePreviewEditionPanel().addExit(this.dataControl.getLastExit());
            this.iaep.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getExits().add(this.newExit);
        this.dataControl.getExitsList().add((Exit)this.newExit.getContent());
        this.iaep.getScenePreviewEditionPanel().addExit(this.newExit);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newExit, false);
        this.iaep.getScenePreviewEditionPanel().removeElement(this.newExit);
        Controller.getInstance().updatePanel();
        return true;
    }
}

