/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarriersListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DuplicateBarrierTool
extends Tool {
    private BarriersListDataControl dataControl;
    private ScenePreviewEditionPanel spep;
    private JTable table;
    private BarrierDataControl newBarrier;

    public DuplicateBarrierTool(BarriersListDataControl barriersListDataControl, ScenePreviewEditionPanel scenePreviewEditionPanel, JTable jTable) {
        this.dataControl = barriersListDataControl;
        this.table = jTable;
        this.spep = scenePreviewEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getBarriers().get(this.table.getSelectedRow()))) {
            this.newBarrier = this.dataControl.getLastBarrier();
            this.spep.addBarrier(this.dataControl.getLastBarrier());
            this.spep.repaint();
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            this.table.changeSelection(this.dataControl.getBarriers().size() - 1, this.dataControl.getBarriers().size() - 1, false, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getBarriers().add(this.newBarrier);
        this.dataControl.getBarriersList().add((Barrier)this.newBarrier.getContent());
        this.spep.addBarrier(this.dataControl.getLastBarrier());
        Controller.getInstance().getIdentifierSummary().addActiveAreaId(this.newBarrier.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newBarrier, false);
        this.spep.removeElement(this.newBarrier);
        Controller.getInstance().updatePanel();
        return true;
    }
}

