/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ActiveAreasTable;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import javax.swing.table.AbstractTableModel;

public class DuplicateActiveAreaTool
extends Tool {
    private ActiveAreasListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private ActiveAreasTable table;
    private ActiveAreaDataControl newActiveArea;

    public DuplicateActiveAreaTool(ActiveAreasListDataControl activeAreasListDataControl, IrregularAreaEditionPanel irregularAreaEditionPanel, ActiveAreasTable activeAreasTable) {
        this.dataControl = activeAreasListDataControl;
        this.table = activeAreasTable;
        this.iaep = irregularAreaEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getActiveAreas().get(this.table.getSelectedRow()))) {
            this.newActiveArea = this.dataControl.getLastActiveArea();
            this.iaep.getScenePreviewEditionPanel().addActiveArea(this.dataControl.getLastActiveArea());
            this.iaep.repaint();
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            this.table.changeSelection(this.dataControl.getActiveAreas().size() - 1, this.dataControl.getActiveAreas().size() - 1, false, false);
            this.table.editCellAt(this.dataControl.getActiveAreas().size() - 1, 0);
            if (this.table.isEditing()) {
                this.table.getEditorComponent().requestFocusInWindow();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getActiveAreas().add(this.newActiveArea);
        this.dataControl.getActiveAreasList().add((ActiveArea)this.newActiveArea.getContent());
        this.iaep.getScenePreviewEditionPanel().addActiveArea(this.dataControl.getLastActiveArea());
        Controller.getInstance().getIdentifierSummary().addActiveAreaId(this.newActiveArea.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newActiveArea, false);
        this.iaep.getScenePreviewEditionPanel().removeElement(this.newActiveArea);
        Controller.getInstance().updatePanel();
        return true;
    }
}

