/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.SideDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteTrajectorySideTool
extends Tool {
    private SideDataControl sideDataControl;
    private Trajectory trajectory;
    private TrajectoryDataControl trajectoryDataControl;

    public DeleteTrajectorySideTool(SideDataControl sideDataControl, Trajectory trajectory, TrajectoryDataControl trajectoryDataControl) {
        this.sideDataControl = sideDataControl;
        this.trajectory = trajectory;
        this.trajectoryDataControl = trajectoryDataControl;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.trajectoryDataControl.getSides().remove(this.sideDataControl);
        this.trajectory.getSides().remove(this.sideDataControl.getContent());
        return true;
    }

    @Override
    public boolean redoTool() {
        this.trajectoryDataControl.getSides().remove(this.sideDataControl);
        this.trajectory.getSides().remove(this.sideDataControl.getContent());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.trajectoryDataControl.getSides().add(this.sideDataControl);
        this.trajectory.getSides().add((Trajectory.Side)this.sideDataControl.getContent());
        Controller.getInstance().updatePanel();
        return true;
    }
}

