/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SideDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class DeleteTrajectoryNodeTool
extends Tool {
    NodeDataControl oldNodeDataControl;
    Trajectory trajectory;
    TrajectoryDataControl trajectoryDataControl;
    List<SideDataControl> oldSides;
    private boolean wasInitial;

    public DeleteTrajectoryNodeTool(DataControl dataControl, Trajectory trajectory, TrajectoryDataControl trajectoryDataControl) {
        this.oldNodeDataControl = (NodeDataControl)dataControl;
        this.trajectory = trajectory;
        this.trajectoryDataControl = trajectoryDataControl;
        this.oldSides = new ArrayList<SideDataControl>();
        this.wasInitial = trajectoryDataControl.getInitialNode() == this.oldNodeDataControl;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        Trajectory.Node node = (Trajectory.Node)this.oldNodeDataControl.getContent();
        this.trajectory.removeNode(node.getX(), node.getY());
        this.trajectoryDataControl.getNodes().remove(this.oldNodeDataControl);
        if (this.wasInitial) {
            this.trajectory.setInitial(null);
            this.trajectoryDataControl.initialNode = null;
            this.trajectory.setInitial(((Trajectory.Node)this.trajectory.getNodes().get(0)).getID());
            this.trajectoryDataControl.initialNode = this.trajectoryDataControl.getNodes().get(0);
        }
        for (SideDataControl sideDataControl : this.trajectoryDataControl.getSides()) {
            if (this.trajectory.getSides().contains(sideDataControl.getContent())) continue;
            this.oldSides.add(sideDataControl);
        }
        for (SideDataControl sideDataControl : this.oldSides) {
            this.trajectoryDataControl.getSides().remove(sideDataControl);
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        Trajectory.Node node = (Trajectory.Node)this.oldNodeDataControl.getContent();
        this.trajectory.removeNode(node.getX(), node.getY());
        this.trajectoryDataControl.getNodes().remove(this.oldNodeDataControl);
        if (this.wasInitial) {
            this.trajectory.setInitial(null);
            this.trajectoryDataControl.initialNode = null;
            this.trajectory.setInitial(((Trajectory.Node)this.trajectory.getNodes().get(0)).getID());
            this.trajectoryDataControl.initialNode = this.trajectoryDataControl.getNodes().get(0);
        }
        for (SideDataControl sideDataControl : this.trajectoryDataControl.getSides()) {
            if (this.trajectory.getSides().contains(sideDataControl.getContent())) continue;
            this.oldSides.add(sideDataControl);
        }
        for (SideDataControl sideDataControl : this.oldSides) {
            this.trajectoryDataControl.getSides().remove(sideDataControl);
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        Trajectory.Node node = (Trajectory.Node)this.oldNodeDataControl.getContent();
        this.trajectory.getNodes().add(node);
        this.trajectoryDataControl.getNodes().add(this.oldNodeDataControl);
        if (this.wasInitial) {
            this.trajectory.setInitial(node.getID());
            this.trajectoryDataControl.initialNode = this.oldNodeDataControl;
        }
        for (SideDataControl sideDataControl : this.oldSides) {
            this.trajectory.getSides().add((Trajectory.Side)sideDataControl.getContent());
            this.trajectoryDataControl.getSides().add(sideDataControl);
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

