/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ElementReferencesTable;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;

public class DeleteReferenceTool
extends Tool {
    private ReferencesListDataControl referencesListDataControl;
    private ScenePreviewEditionPanel spep;
    private ElementReferencesTable table;
    private ElementContainer element;
    private int selectedRow;

    public DeleteReferenceTool(ReferencesListDataControl referencesListDataControl, ElementReferencesTable elementReferencesTable, ScenePreviewEditionPanel scenePreviewEditionPanel) {
        this.table = elementReferencesTable;
        this.referencesListDataControl = referencesListDataControl;
        this.spep = scenePreviewEditionPanel;
        this.selectedRow = elementReferencesTable.getSelectedRow();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.element = this.referencesListDataControl.getAllReferencesDataControl().get(this.selectedRow);
        if (this.referencesListDataControl.deleteElement(this.element.getErdc(), true) && !this.element.isPlayer()) {
            this.spep.removeElement(ReferencesListDataControl.transformType(this.element.getErdc().getType()), this.element.getErdc());
            this.table.clearSelection();
            this.table.changeSelection(0, 1, false, false);
            this.table.updateUI();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        ElementContainer elementContainer = this.referencesListDataControl.getAllReferencesDataControl().get(this.selectedRow);
        if (this.referencesListDataControl.deleteElement(elementContainer.getErdc(), true)) {
            if (!elementContainer.isPlayer()) {
                this.spep.removeElement(ReferencesListDataControl.transformType(elementContainer.getErdc().getType()), elementContainer.getErdc());
                this.table.clearSelection();
                this.table.changeSelection(0, 1, false, false);
                this.table.updateUI();
            }
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        this.referencesListDataControl.addElement(this.element);
        this.spep.addElement(this.element.getErdc().getType(), this.element.getErdc());
        this.table.clearSelection();
        this.table.changeSelection(this.selectedRow, 1, false, false);
        this.table.updateUI();
        Controller.getInstance().updatePanel();
        return true;
    }
}

