/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Exit;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ExitDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ExitsListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DeleteExitTool
extends Tool {
    private ExitsListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private JTable table;
    private ExitDataControl element;
    private int position;

    public DeleteExitTool(ExitsListDataControl exitsListDataControl, JTable jTable, IrregularAreaEditionPanel irregularAreaEditionPanel) {
        this.dataControl = exitsListDataControl;
        this.table = jTable;
        this.iaep = irregularAreaEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        int n = this.table.getSelectedRow();
        this.element = this.dataControl.getExits().get(n);
        this.iaep.getScenePreviewEditionPanel().removeElement(this.element);
        this.iaep.setRectangular(null);
        this.iaep.getScenePreviewEditionPanel().setSelectedElement((ImageElement)null);
        this.dataControl.deleteElement(this.element, true);
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        return true;
    }

    @Override
    public boolean redoTool() {
        this.iaep.getScenePreviewEditionPanel().removeElement(this.element);
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getExitsList().add(this.position, (Exit)this.element.getContent());
        this.dataControl.getExits().add(this.position, this.element);
        this.iaep.getScenePreviewEditionPanel().addExit(this.element);
        Controller.getInstance().updatePanel();
        return true;
    }
}

