/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarriersListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DeleteBarrierTool
extends Tool {
    private BarriersListDataControl dataControl;
    private ScenePreviewEditionPanel spep;
    private JTable table;
    private BarrierDataControl element;
    private int position;

    public DeleteBarrierTool(BarriersListDataControl barriersListDataControl, JTable jTable, ScenePreviewEditionPanel scenePreviewEditionPanel) {
        this.dataControl = barriersListDataControl;
        this.table = jTable;
        this.spep = scenePreviewEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        int n = this.table.getSelectedRow();
        this.element = this.dataControl.getBarriers().get(n);
        this.dataControl.deleteElement(this.element, true);
        this.spep.removeElement(this.element);
        this.spep.updateUI();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        return true;
    }

    @Override
    public boolean redoTool() {
        this.spep.removeElement(this.element);
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getBarriersList().add(this.position, (Barrier)this.element.getContent());
        this.dataControl.getBarriers().add(this.position, this.element);
        this.spep.addBarrier(this.element);
        Controller.getInstance().updatePanel();
        return true;
    }
}

