/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ActiveAreasTable;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElement;
import javax.swing.table.AbstractTableModel;

public class DeleteActiveAreaTool
extends Tool {
    private ActiveAreasListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private ActiveAreasTable table;
    private ActiveAreaDataControl element;
    private int position;
    private ChapterDataControl chapterDataControl;
    private Chapter chapter;

    public DeleteActiveAreaTool(ActiveAreasListDataControl activeAreasListDataControl, IrregularAreaEditionPanel irregularAreaEditionPanel, ActiveAreasTable activeAreasTable) {
        this.dataControl = activeAreasListDataControl;
        this.table = activeAreasTable;
        this.iaep = irregularAreaEditionPanel;
        this.chapterDataControl = Controller.getInstance().getSelectedChapterDataControl();
        try {
            this.chapter = (Chapter)((Chapter)this.chapterDataControl.getContent()).clone();
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"Could not clone chapter");
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.chapter != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.position = this.table.getSelectedRow();
        this.element = this.dataControl.getActiveAreas().get(this.position);
        if (this.dataControl.deleteElement(this.element, true)) {
            this.iaep.getScenePreviewEditionPanel().removeElement(this.element);
            this.iaep.setRectangular(null);
            this.iaep.getScenePreviewEditionPanel().setSelectedElement((ImageElement)null);
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        Controller.getInstance().replaceSelectedChapter((Chapter)this.chapterDataControl.getContent());
        Controller.getInstance().reloadData();
        return true;
    }

    @Override
    public boolean undoTool() {
        Controller.getInstance().replaceSelectedChapter(this.chapter);
        Controller.getInstance().reloadData();
        return true;
    }
}

