/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangePlayerScaleTool
extends Tool {
    private Scene scene;
    private float scale;
    private float oldScale;

    public ChangePlayerScaleTool(Scene scene, float f) {
        this.scene = scene;
        this.scale = f;
        this.oldScale = scene.getPlayerScale();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangePlayerScaleTool) {
            ChangePlayerScaleTool changePlayerScaleTool = (ChangePlayerScaleTool)tool;
            if (changePlayerScaleTool.scene == this.scene) {
                this.scale = changePlayerScaleTool.scale;
                this.timeStamp = changePlayerScaleTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.scene.setPlayerScale(this.scale);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.scene.setPlayerScale(this.scale);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.scene.setPlayerScale(this.oldScale);
        Controller.getInstance().updatePanel();
        return true;
    }
}

