/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.Random;

public class ChangeHasTrajectoryTool
extends Tool {
    private boolean selected;
    private SceneDataControl sceneDataControl;
    private TrajectoryDataControl oldTrajectoryDataControl;
    private TrajectoryDataControl newTrajectoryDataControl;

    public ChangeHasTrajectoryTool(boolean bl, SceneDataControl sceneDataControl) {
        this.selected = bl;
        this.sceneDataControl = sceneDataControl;
        this.oldTrajectoryDataControl = sceneDataControl.getTrajectory();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.selected == this.sceneDataControl.getTrajectory().hasTrajectory()) {
            return false;
        }
        if (!this.selected) {
            this.newTrajectoryDataControl = new TrajectoryDataControl(this.sceneDataControl, null);
            this.sceneDataControl.setTrajectory(null);
            this.sceneDataControl.setTrajectoryDataControl(this.newTrajectoryDataControl);
        } else {
            Trajectory trajectory = new Trajectory();
            trajectory.addNode("node" + new Random().nextInt(10000), 300, 300, 1.0f);
            this.newTrajectoryDataControl = new TrajectoryDataControl(this.sceneDataControl, trajectory);
            this.sceneDataControl.setTrajectory(trajectory);
            this.sceneDataControl.setTrajectoryDataControl(this.newTrajectoryDataControl);
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        if (this.newTrajectoryDataControl.hasTrajectory()) {
            this.sceneDataControl.setTrajectory((Trajectory)this.newTrajectoryDataControl.getContent());
        } else {
            this.sceneDataControl.setTrajectory(null);
        }
        this.sceneDataControl.setTrajectoryDataControl(this.newTrajectoryDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        if (this.oldTrajectoryDataControl.hasTrajectory()) {
            this.sceneDataControl.setTrajectory((Trajectory)this.oldTrajectoryDataControl.getContent());
        } else {
            this.sceneDataControl.setTrajectory(null);
        }
        this.sceneDataControl.setTrajectoryDataControl(this.oldTrajectoryDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

