/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SideDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddTrajectorySideTool
extends Tool {
    private NodeDataControl startNode;
    private NodeDataControl endNode;
    private Trajectory trajectory;
    private TrajectoryDataControl trajectoryDataControl;
    private SceneDataControl sceneDataControl;
    private Trajectory.Side newSide;
    private SideDataControl newSideDataControl;

    public AddTrajectorySideTool(NodeDataControl nodeDataControl, NodeDataControl nodeDataControl2, Trajectory trajectory, TrajectoryDataControl trajectoryDataControl, SceneDataControl sceneDataControl) {
        this.startNode = nodeDataControl;
        this.endNode = nodeDataControl2;
        this.trajectory = trajectory;
        this.trajectoryDataControl = trajectoryDataControl;
        this.sceneDataControl = sceneDataControl;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.newSide = this.trajectory.addSide(this.startNode.getID(), this.endNode.getID(), -1);
        if (this.newSide != null) {
            this.newSideDataControl = new SideDataControl(this.sceneDataControl, this.trajectoryDataControl, this.newSide);
            this.trajectoryDataControl.getSides().add(this.newSideDataControl);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.trajectory.getSides().add(this.newSide);
        this.trajectoryDataControl.getSides().add(this.newSideDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.trajectory.getSides().remove(this.newSide);
        this.trajectoryDataControl.getSides().remove(this.newSideDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

