/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.Trajectory;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.NodeDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.TrajectoryDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.Random;

public class AddTrajectoryNodeTool
extends Tool {
    private Trajectory trajectory;
    private TrajectoryDataControl trajectoryDataControl;
    private int x;
    private int y;
    private Trajectory.Node newNode;
    private NodeDataControl newNodeDataControl;
    private SceneDataControl sceneDataControl;
    private boolean wasInitial;

    public AddTrajectoryNodeTool(Trajectory trajectory, TrajectoryDataControl trajectoryDataControl, int n, int n2, SceneDataControl sceneDataControl) {
        this.trajectory = trajectory;
        this.trajectoryDataControl = trajectoryDataControl;
        this.x = n;
        this.y = n2;
        this.sceneDataControl = sceneDataControl;
        this.wasInitial = false;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        String string = "node" + new Random().nextInt(10000);
        this.newNode = this.trajectory.addNode(string, this.x, this.y, 1.0f);
        this.newNodeDataControl = new NodeDataControl(this.sceneDataControl, this.newNode, this.trajectory);
        this.trajectoryDataControl.getNodes().add(this.newNodeDataControl);
        if (this.trajectory.getInitial() == this.newNode) {
            this.trajectoryDataControl.initialNode = this.newNodeDataControl;
            this.wasInitial = true;
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        this.trajectory.getNodes().add(this.newNode);
        this.trajectoryDataControl.getNodes().add(this.newNodeDataControl);
        if (this.wasInitial) {
            this.trajectory.setInitial(this.newNode.getID());
            this.trajectoryDataControl.initialNode = this.newNodeDataControl;
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.trajectoryDataControl.getNodes().remove(this.newNodeDataControl);
        if (this.wasInitial) {
            this.trajectoryDataControl.initialNode = null;
            this.trajectory.setInitial(null);
        }
        this.trajectory.getNodes().remove(this.newNode);
        Controller.getInstance().updatePanel();
        return true;
    }
}

