/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ElementReferencesTable;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;

public class AddReferenceTool
extends Tool {
    private ReferencesListDataControl referencesListDataControl;
    private int type;
    private ScenePreviewEditionPanel spep;
    private ElementReferencesTable table;
    private ElementContainer newElement;

    public AddReferenceTool(ReferencesListDataControl referencesListDataControl, int n, ScenePreviewEditionPanel scenePreviewEditionPanel, ElementReferencesTable elementReferencesTable) {
        this.referencesListDataControl = referencesListDataControl;
        this.type = n;
        this.spep = scenePreviewEditionPanel;
        this.table = elementReferencesTable;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        int n;
        if (this.referencesListDataControl.addElement(this.type, null) && (n = ReferencesListDataControl.transformType(this.type)) != 0 && this.referencesListDataControl.getLastElementContainer() != null) {
            this.newElement = this.referencesListDataControl.getLastElementContainer();
            this.spep.addElement(n, this.newElement.getErdc());
            this.spep.setSelectedElement(this.newElement.getErdc());
            this.spep.repaint();
            int n2 = this.newElement.getErdc().getElementReference().getLayer();
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.table.updateUI();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.referencesListDataControl.addElement(this.newElement);
        int n = ReferencesListDataControl.transformType(this.type);
        this.spep.addElement(n, this.newElement.getErdc());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.referencesListDataControl.deleteElement(this.newElement.getErdc(), false);
        int n = ReferencesListDataControl.transformType(this.type);
        this.spep.removeElement(n, this.newElement.getErdc());
        Controller.getInstance().updatePanel();
        return true;
    }
}

