/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.elements.Barrier;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.BarrierDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.BarriersListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.ScenePreviewEditionPanel;

public class AddBarrierTool
extends Tool {
    private BarriersListDataControl dataControl;
    private ScenePreviewEditionPanel spep;
    private String id;
    private BarrierDataControl newBarrier;

    public AddBarrierTool(BarriersListDataControl barriersListDataControl, String string, ScenePreviewEditionPanel scenePreviewEditionPanel) {
        this.dataControl = barriersListDataControl;
        this.id = string;
        this.spep = scenePreviewEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.addElement(this.dataControl.getAddableElements()[0], this.id)) {
            this.newBarrier = this.dataControl.getLastBarrier();
            this.spep.addBarrier(this.dataControl.getLastBarrier());
            this.spep.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getBarriersList().add((Barrier)this.newBarrier.getContent());
        this.dataControl.getBarriers().add(this.newBarrier);
        this.spep.addBarrier(this.dataControl.getLastBarrier());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newBarrier, false);
        this.spep.removeElement(this.newBarrier);
        Controller.getInstance().updatePanel();
        return true;
    }
}

