/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.scene;

import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreaDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.ActiveAreasListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.otherpanels.IrregularAreaEditionPanel;

public class AddActiveAreaTool
extends Tool {
    private ActiveAreasListDataControl dataControl;
    private IrregularAreaEditionPanel iaep;
    private String id;
    private ActiveAreaDataControl newActiveArea;

    public AddActiveAreaTool(ActiveAreasListDataControl activeAreasListDataControl, String string, IrregularAreaEditionPanel irregularAreaEditionPanel) {
        this.dataControl = activeAreasListDataControl;
        this.id = string;
        this.iaep = irregularAreaEditionPanel;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.addElement(this.dataControl.getAddableElements()[0], this.id)) {
            this.newActiveArea = this.dataControl.getLastActiveArea();
            this.iaep.getScenePreviewEditionPanel().addActiveArea(this.dataControl.getLastActiveArea());
            this.iaep.repaint();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getActiveAreas().add(this.newActiveArea);
        this.dataControl.getActiveAreasList().add((ActiveArea)this.newActiveArea.getContent());
        this.iaep.getScenePreviewEditionPanel().addActiveArea(this.dataControl.getLastActiveArea());
        Controller.getInstance().getIdentifierSummary().addActiveAreaId(this.newActiveArea.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newActiveArea, false);
        this.iaep.getScenePreviewEditionPanel().removeElement(this.newActiveArea);
        Controller.getInstance().updatePanel();
        return true;
    }
}

