/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.macro;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class RenameMacroTool
extends Tool {
    private DataControl dataControl;
    private String oldName;
    private String newName;

    public RenameMacroTool(DataControl dataControl, String string) {
        this.dataControl = dataControl;
        this.newName = string;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldName != null;
    }

    @Override
    public boolean doTool() {
        if (this.newName.length() == 0) {
            return false;
        }
        if (this.dataControl.canBeRenamed()) {
            this.oldName = this.dataControl.renameElement(this.newName);
            if (this.oldName != null && !this.oldName.equals(this.newName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.dataControl.canBeRenamed()) {
            this.oldName = this.dataControl.renameElement(this.newName);
            if (this.oldName != null) {
                Controller.getInstance().updatePanel();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.dataControl.canBeRenamed()) {
            this.newName = this.dataControl.renameElement(this.oldName);
            if (this.newName != null) {
                Controller.getInstance().updatePanel();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

