/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.macro;

import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.macro.MacroDataControl;
import es.eucm.eadventure.editor.control.controllers.macro.MacroListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteMacroTool
extends Tool {
    private MacroListDataControl dataControl;
    private MacroDataControl element;
    private int position;

    public DeleteMacroTool(MacroListDataControl macroListDataControl, int n) {
        this.dataControl = macroListDataControl;
        this.position = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.element = this.dataControl.getMacros().get(this.position);
        this.dataControl.deleteElement(this.dataControl.getMacros().get(this.position), true);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().getIdentifierSummary().deleteMacroId(this.element.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getMacrosList().add(this.position, (Macro)this.element.getContent());
        this.dataControl.getMacros().add(this.position, this.element);
        Controller.getInstance().getIdentifierSummary().addMacroId(this.element.getId());
        Controller.getInstance().updatePanel();
        return true;
    }
}

