/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.macro;

import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.macro.MacroDataControl;
import es.eucm.eadventure.editor.control.controllers.macro.MacroListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddMacroTool
extends Tool {
    private MacroListDataControl dataControl;
    private MacroDataControl newMacro;

    public AddMacroTool(MacroListDataControl macroListDataControl) {
        this.dataControl = macroListDataControl;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.addElement(this.dataControl.getAddableElements()[0], null)) {
            this.newMacro = this.dataControl.getLastMacro();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getMacros().add(this.newMacro);
        this.dataControl.getMacrosList().add((Macro)this.newMacro.getContent());
        Controller.getInstance().getIdentifierSummary().addMacroId(this.newMacro.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newMacro, false);
        Controller.getInstance().getIdentifierSummary().deleteMacroId(this.newMacro.getId());
        Controller.getInstance().updatePanel();
        return true;
    }
}

