/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.globalstate;

import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateDataControl;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DuplicateGlobalStateTool
extends Tool {
    private GlobalStateListDataControl dataControl;
    private GlobalStateDataControl newGlobalState;
    private int selected;

    public DuplicateGlobalStateTool(GlobalStateListDataControl globalStateListDataControl, int n) {
        this.dataControl = globalStateListDataControl;
        this.selected = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getGlobalStates().get(this.selected))) {
            this.newGlobalState = this.dataControl.getLastGlobalState();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getGlobalStates().add(this.newGlobalState);
        this.dataControl.getGlobalStatesList().add((GlobalState)this.newGlobalState.getContent());
        Controller.getInstance().getIdentifierSummary().addGlobalStateId(this.newGlobalState.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newGlobalState, false);
        Controller.getInstance().getIdentifierSummary().deleteGlobalStateId(this.newGlobalState.getId());
        Controller.getInstance().updatePanel();
        return true;
    }
}

