/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.globalstate;

import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateDataControl;
import es.eucm.eadventure.editor.control.controllers.globalstate.GlobalStateListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteGlobalStateTool
extends Tool {
    private GlobalStateListDataControl dataControl;
    private GlobalStateDataControl element;
    private int position;

    public DeleteGlobalStateTool(GlobalStateListDataControl globalStateListDataControl, int n) {
        this.dataControl = globalStateListDataControl;
        this.position = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.element = this.dataControl.getGlobalStates().get(this.position);
        this.dataControl.deleteElement(this.dataControl.getGlobalStates().get(this.position), true);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().getIdentifierSummary().deleteGlobalStateId(this.element.getId());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getGlobalStatesList().add(this.position, (GlobalState)this.element.getContent());
        this.dataControl.getGlobalStates().add(this.position, this.element);
        Controller.getInstance().getIdentifierSummary().addGlobalStateId(this.element.getId());
        Controller.getInstance().updatePanel();
        return true;
    }
}

