/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.generic;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.lang.reflect.Method;

public class ChangeIntegerValueTool
extends Tool {
    protected Method get;
    protected Method set;
    protected String getName;
    protected String setName;
    protected Integer oldValue;
    protected Integer newValue;
    protected Object data;
    protected boolean updateTree;
    protected boolean updatePanel;

    public ChangeIntegerValueTool(Object object, Integer n, String string, String string2) {
        this(object, n, string, string2, false, true);
    }

    public ChangeIntegerValueTool(Object object, Integer n, String string, String string2, boolean bl, boolean bl2) {
        this.data = object;
        this.newValue = n;
        this.updatePanel = bl2;
        this.updateTree = bl;
        try {
            this.set = object.getClass().getMethod(string2, Integer.class);
            this.get = object.getClass().getMethod(string, new Class[0]);
            this.getName = string;
            this.setName = string2;
            if (this.get.getReturnType() != Integer.class) {
                this.set = null;
                this.get = null;
                this.setName = null;
                this.getName = null;
                ReportDialog.GenerateErrorReport((Exception)new Exception("Get method must return Integer value"), (boolean)false, (String)TC.get((String)"Error.Title"));
            }
        }
        catch (SecurityException securityException) {
            this.set = null;
            this.get = null;
            this.setName = null;
            this.getName = null;
            ReportDialog.GenerateErrorReport((Exception)securityException, (boolean)false, (String)TC.get((String)"Error.Title"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.set = null;
            this.get = null;
            this.setName = null;
            this.getName = null;
            ReportDialog.GenerateErrorReport((Exception)noSuchMethodException, (boolean)false, (String)TC.get((String)"Error.Title"));
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.get != null && this.set != null) {
            try {
                this.oldValue = (Integer)this.get.invoke(this.data, new Object[0]);
                if (this.newValue != null && this.oldValue == null || this.newValue == null && this.oldValue != null || this.newValue != null && this.oldValue != null && !this.oldValue.equals(this.newValue)) {
                    this.set.invoke(this.data, this.newValue);
                    bl = true;
                }
            }
            catch (Exception exception) {
                ReportDialog.GenerateErrorReport((Exception)exception, (boolean)false, (String)TC.get((String)"Error.Title"));
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = false;
        try {
            this.set.invoke(this.data, this.newValue);
            if (this.updateTree) {
                Controller.getInstance().updateStructure();
            }
            if (this.updatePanel) {
                Controller.getInstance().updatePanel();
            }
            bl = true;
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)false, (String)TC.get((String)"Error.Title"));
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = false;
        try {
            this.set.invoke(this.data, this.oldValue);
            if (this.updateTree) {
                Controller.getInstance().updateStructure();
            }
            if (this.updatePanel) {
                Controller.getInstance().updatePanel();
            }
            bl = true;
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)false, (String)TC.get((String)"Error.Title"));
        }
        return bl;
    }
}

