/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.effects;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.ConsumeObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.GenerateObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.HighlightItemEffect;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.MacroReferenceEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveNPCEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.MovePlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerBookEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerCutsceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.WaitTimeEffect;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.HashMap;

public class ReplaceEffectTool
extends Tool {
    protected Effects effects;
    protected AbstractEffect effect;
    protected HashMap<Integer, Object> newProperties;
    protected AbstractEffect oldEffect;
    protected AbstractEffect pos;
    protected AbstractEffect neg;

    public ReplaceEffectTool(Effects effects, AbstractEffect abstractEffect, HashMap<Integer, Object> hashMap) {
        this(effects, abstractEffect, hashMap, null, null);
    }

    public ReplaceEffectTool(Effects effects, AbstractEffect abstractEffect, HashMap<Integer, Object> hashMap, AbstractEffect abstractEffect2, AbstractEffect abstractEffect3) {
        this.effects = effects;
        this.effect = abstractEffect;
        this.pos = abstractEffect2;
        this.neg = abstractEffect3;
        this.newProperties = hashMap;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldEffect != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        int n = this.effect.getType();
        if (this.newProperties != null) {
            bl = true;
            try {
                this.oldEffect = (AbstractEffect)this.effect.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)("Error cloning effect " + this.effect.getType()));
            }
            switch (n) {
                case 0: {
                    ActivateEffect activateEffect = (ActivateEffect)this.effect;
                    activateEffect.setTargetId((String)this.newProperties.get(0));
                    Controller.getInstance().updateVarFlagSummary();
                    break;
                }
                case 1: {
                    DeactivateEffect deactivateEffect = (DeactivateEffect)this.effect;
                    deactivateEffect.setTargetId((String)this.newProperties.get(0));
                    Controller.getInstance().updateVarFlagSummary();
                    break;
                }
                case 17: {
                    SetValueEffect setValueEffect = (SetValueEffect)this.effect;
                    setValueEffect.setTargetId((String)this.newProperties.get(0));
                    setValueEffect.setValue(Integer.parseInt((String)this.newProperties.get(7)));
                    Controller.getInstance().updateVarFlagSummary();
                    break;
                }
                case 18: {
                    IncrementVarEffect incrementVarEffect = (IncrementVarEffect)this.effect;
                    incrementVarEffect.setTargetId((String)this.newProperties.get(0));
                    incrementVarEffect.setIncrement(Integer.parseInt((String)this.newProperties.get(7)));
                    Controller.getInstance().updateVarFlagSummary();
                    break;
                }
                case 19: {
                    DecrementVarEffect decrementVarEffect = (DecrementVarEffect)this.effect;
                    decrementVarEffect.setTargetId((String)this.newProperties.get(0));
                    decrementVarEffect.setDecrement(Integer.parseInt((String)this.newProperties.get(7)));
                    Controller.getInstance().updateVarFlagSummary();
                    break;
                }
                case 20: {
                    MacroReferenceEffect macroReferenceEffect = (MacroReferenceEffect)this.effect;
                    macroReferenceEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 2: {
                    ConsumeObjectEffect consumeObjectEffect = (ConsumeObjectEffect)this.effect;
                    consumeObjectEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 3: {
                    GenerateObjectEffect generateObjectEffect = (GenerateObjectEffect)this.effect;
                    generateObjectEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 5: {
                    SpeakPlayerEffect speakPlayerEffect = (SpeakPlayerEffect)this.effect;
                    speakPlayerEffect.setLine((String)this.newProperties.get(2));
                    break;
                }
                case 6: {
                    SpeakCharEffect speakCharEffect = (SpeakCharEffect)this.effect;
                    speakCharEffect.setTargetId((String)this.newProperties.get(0));
                    speakCharEffect.setLine((String)this.newProperties.get(2));
                    break;
                }
                case 7: {
                    TriggerBookEffect triggerBookEffect = (TriggerBookEffect)this.effect;
                    triggerBookEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 8: {
                    PlaySoundEffect playSoundEffect = (PlaySoundEffect)this.effect;
                    playSoundEffect.setPath((String)this.newProperties.get(1));
                    playSoundEffect.setBackground(Boolean.parseBoolean((String)this.newProperties.get(5)));
                    break;
                }
                case 9: {
                    PlayAnimationEffect playAnimationEffect = (PlayAnimationEffect)this.effect;
                    playAnimationEffect.setPath((String)this.newProperties.get(1));
                    playAnimationEffect.setDestiny(Integer.parseInt((String)this.newProperties.get(3)), Integer.parseInt((String)this.newProperties.get(4)));
                    break;
                }
                case 10: {
                    MovePlayerEffect movePlayerEffect = (MovePlayerEffect)this.effect;
                    movePlayerEffect.setDestiny(Integer.parseInt((String)this.newProperties.get(3)), Integer.parseInt((String)this.newProperties.get(4)));
                    break;
                }
                case 11: {
                    MoveNPCEffect moveNPCEffect = (MoveNPCEffect)this.effect;
                    moveNPCEffect.setTargetId((String)this.newProperties.get(0));
                    moveNPCEffect.setDestiny(Integer.parseInt((String)this.newProperties.get(3)), Integer.parseInt((String)this.newProperties.get(4)));
                    break;
                }
                case 12: {
                    TriggerConversationEffect triggerConversationEffect = (TriggerConversationEffect)this.effect;
                    triggerConversationEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 13: {
                    TriggerCutsceneEffect triggerCutsceneEffect = (TriggerCutsceneEffect)this.effect;
                    triggerCutsceneEffect.setTargetId((String)this.newProperties.get(0));
                    break;
                }
                case 14: {
                    TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)this.effect;
                    triggerSceneEffect.setTargetId((String)this.newProperties.get(0));
                    triggerSceneEffect.setPosition(Integer.parseInt((String)this.newProperties.get(3)), Integer.parseInt((String)this.newProperties.get(4)));
                    break;
                }
                case 16: {
                    RandomEffect randomEffect = (RandomEffect)this.effect;
                    randomEffect.setProbability(Integer.parseInt((String)this.newProperties.get(6)));
                    randomEffect.setPositiveEffect(this.pos);
                    randomEffect.setNegativeEffect(this.neg);
                    break;
                }
                case 21: {
                    WaitTimeEffect waitTimeEffect = (WaitTimeEffect)this.effect;
                    waitTimeEffect.setTime(Integer.parseInt((String)this.newProperties.get(8)));
                    break;
                }
                case 22: {
                    ShowTextEffect showTextEffect = (ShowTextEffect)this.effect;
                    showTextEffect.setText((String)this.newProperties.get(2));
                    showTextEffect.setTextPosition(Integer.parseInt((String)this.newProperties.get(3)), Integer.parseInt((String)this.newProperties.get(4)));
                    showTextEffect.setRgbFrontColor(Integer.parseInt((String)this.newProperties.get(9)));
                    showTextEffect.setRgbBorderColor(Integer.parseInt((String)this.newProperties.get(10)));
                    break;
                }
                case 23: {
                    HighlightItemEffect highlightItemEffect = (HighlightItemEffect)this.effect;
                    highlightItemEffect.setTargetId((String)this.newProperties.get(0));
                    highlightItemEffect.setHighlightAnimated(((Boolean)this.newProperties.get(15)).booleanValue());
                    highlightItemEffect.setHighlightType(((Integer)this.newProperties.get(14)).intValue());
                    break;
                }
                case 24: {
                    MoveObjectEffect moveObjectEffect = (MoveObjectEffect)this.effect;
                    moveObjectEffect.setTargetId((String)this.newProperties.get(0));
                    moveObjectEffect.setX(Integer.parseInt((String)this.newProperties.get(3)));
                    moveObjectEffect.setY(Integer.parseInt((String)this.newProperties.get(4)));
                    moveObjectEffect.setScale(((Float)this.newProperties.get(16)).floatValue());
                    moveObjectEffect.setAnimated(((Boolean)this.newProperties.get(15)).booleanValue());
                    moveObjectEffect.setScaleSpeed(((Integer)this.newProperties.get(18)).intValue());
                    moveObjectEffect.setTranslateSpeed(((Integer)this.newProperties.get(17)).intValue());
                }
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        int n = this.effects.getEffects().indexOf(this.oldEffect);
        this.effects.getEffects().remove(this.oldEffect);
        this.effects.getEffects().add(n, this.effect);
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        int n = this.effects.getEffects().indexOf(this.effect);
        this.effects.getEffects().remove(this.effect);
        this.effects.getEffects().add(n, this.oldEffect);
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }
}

