/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.effects;

import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class MoveEffectInTableTool
extends Tool {
    public static final int MODE_UP = 0;
    public static final int MODE_DOWN = 1;
    private Effects effects;
    private int index;
    private int newIndex;
    private int mode;
    private List<ConditionsController> conditions;

    public MoveEffectInTableTool(Effects effects, int n, int n2, List<ConditionsController> list) {
        this.effects = effects;
        this.index = n;
        this.mode = n2;
        this.conditions = list;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (this.mode == 0) {
            this.newIndex = this.moveUp();
        } else if (this.mode == 1) {
            this.newIndex = this.moveDown();
        }
        return this.newIndex != -1;
    }

    @Override
    public boolean redoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            bl = this.moveUp() != -1;
        } else if (this.mode == 1) {
            boolean bl2 = bl = this.moveDown() != -1;
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            int n = this.index;
            this.index = this.newIndex;
            bl = this.moveDown() != -1;
            this.index = n;
        } else if (this.mode == 1) {
            int n = this.index;
            this.index = this.newIndex;
            bl = this.moveUp() != -1;
            this.index = n;
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    private int moveUp() {
        int n = -1;
        if (this.index > 0) {
            this.effects.getEffects().add(this.index - 1, this.effects.getEffects().remove(this.index));
            this.conditions.add(this.index - 1, this.conditions.remove(this.index));
            n = this.index - 1;
        }
        return n;
    }

    private int moveDown() {
        int n = -1;
        if (this.index < this.effects.getEffects().size() - 1) {
            this.effects.getEffects().add(this.index + 1, this.effects.getEffects().remove(this.index));
            this.conditions.add(this.index + 1, this.conditions.remove(this.index));
            n = this.index + 1;
        }
        return n;
    }
}

