/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.effects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteEffectTool
extends Tool {
    protected Effects effects;
    protected AbstractEffect effectDeleted;
    protected int index;
    protected Controller controller;
    protected List<ConditionsController> conditions;
    protected ConditionsController condition;

    public DeleteEffectTool(Effects effects, int n, List<ConditionsController> list) {
        this.effects = effects;
        this.index = n;
        this.conditions = list;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.effectDeleted = (AbstractEffect)this.effects.getEffects().remove(this.index);
        this.condition = this.conditions.remove(this.index);
        this.updateVarFlagSummary((Effect)this.effectDeleted);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.effects.getEffects().remove(this.index);
        this.conditions.remove(this.index);
        this.updateVarFlagSummary((Effect)this.effectDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.effects.getEffects().add(this.index, this.effectDeleted);
        this.conditions.add(this.index, this.condition);
        this.undoUpdateVarFlagSummary((Effect)this.effectDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }

    protected void updateVarFlagSummary(Effect effect) {
        if (effect.getType() == 0) {
            ActivateEffect activateEffect = (ActivateEffect)effect;
            this.controller.getVarFlagSummary().deleteReference(activateEffect.getTargetId());
        } else if (effect.getType() == 1) {
            DeactivateEffect deactivateEffect = (DeactivateEffect)effect;
            this.controller.getVarFlagSummary().deleteReference(deactivateEffect.getTargetId());
        } else if (effect.getType() == 17) {
            SetValueEffect setValueEffect = (SetValueEffect)effect;
            this.controller.getVarFlagSummary().deleteReference(setValueEffect.getTargetId());
        } else if (effect.getType() == 18) {
            IncrementVarEffect incrementVarEffect = (IncrementVarEffect)effect;
            this.controller.getVarFlagSummary().deleteReference(incrementVarEffect.getTargetId());
        } else if (effect.getType() == 19) {
            DecrementVarEffect decrementVarEffect = (DecrementVarEffect)effect;
            this.controller.getVarFlagSummary().deleteReference(decrementVarEffect.getTargetId());
        } else if (effect.getType() == 16) {
            RandomEffect randomEffect = (RandomEffect)effect;
            if (randomEffect.getPositiveEffect() != null) {
                this.updateVarFlagSummary((Effect)randomEffect.getPositiveEffect());
            }
            if (randomEffect.getNegativeEffect() != null) {
                this.updateVarFlagSummary((Effect)randomEffect.getNegativeEffect());
            }
        }
    }

    protected void undoUpdateVarFlagSummary(Effect effect) {
        if (effect.getType() == 0) {
            ActivateEffect activateEffect = (ActivateEffect)effect;
            this.controller.getVarFlagSummary().addReference(activateEffect.getTargetId());
        } else if (effect.getType() == 1) {
            DeactivateEffect deactivateEffect = (DeactivateEffect)effect;
            this.controller.getVarFlagSummary().addReference(deactivateEffect.getTargetId());
        } else if (effect.getType() == 17) {
            SetValueEffect setValueEffect = (SetValueEffect)effect;
            this.controller.getVarFlagSummary().addReference(setValueEffect.getTargetId());
        } else if (effect.getType() == 18) {
            IncrementVarEffect incrementVarEffect = (IncrementVarEffect)effect;
            this.controller.getVarFlagSummary().addReference(incrementVarEffect.getTargetId());
        } else if (effect.getType() == 19) {
            DecrementVarEffect decrementVarEffect = (DecrementVarEffect)effect;
            this.controller.getVarFlagSummary().addReference(decrementVarEffect.getTargetId());
        } else if (effect.getType() == 16) {
            RandomEffect randomEffect = (RandomEffect)effect;
            if (randomEffect.getPositiveEffect() != null) {
                this.undoUpdateVarFlagSummary((Effect)randomEffect.getPositiveEffect());
            }
            if (randomEffect.getNegativeEffect() != null) {
                this.undoUpdateVarFlagSummary((Effect)randomEffect.getNegativeEffect());
            }
        }
    }
}

