/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.effects;

import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.EffectsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class AddEffectTool
extends Tool {
    protected Effects effects;
    protected AbstractEffect effectToAdd;
    protected List<ConditionsController> conditions;
    protected ConditionsController condition;

    public AddEffectTool(Effects effects, AbstractEffect abstractEffect, List<ConditionsController> list) {
        this.effects = effects;
        this.effectToAdd = abstractEffect;
        this.conditions = list;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.effects.add(this.effectToAdd);
        if (this.conditions != null) {
            this.condition = new ConditionsController(this.effectToAdd.getConditions(), 66, EffectsController.getEffectInfo(this.effectToAdd));
            this.conditions.add(this.condition);
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.doTool();
        if (bl) {
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        this.effects.getEffects().remove(this.effectToAdd);
        if (this.conditions != null) {
            this.conditions.remove(this.condition);
        }
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }
}

