/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.FlagCondition;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalStateCondition;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.HashMap;

public class SetConditionTool
extends Tool {
    private Conditions conditions;
    private int index1;
    private int index2;
    private HashMap<String, String> properties;
    private Condition oldCondition;
    private Condition newCondition;

    public SetConditionTool(Conditions conditions, int n, int n2, HashMap<String, String> hashMap) {
        this.conditions = conditions;
        this.index1 = n;
        this.index2 = n2;
        this.properties = hashMap;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        try {
            Condition condition = (Condition)this.conditions.get(this.index1).get(this.index2);
            this.oldCondition = (Condition)condition.clone();
            this.newCondition = null;
            String string = this.properties.get("condition-id");
            String string2 = this.properties.get("condition-type");
            String string3 = this.properties.get("condition-state");
            String string4 = this.properties.get("condition-value");
            int n = ConditionsController.getTypeFromString(string2);
            if (n != condition.getType()) {
                if (n == 1) {
                    this.newCondition = new FlagCondition(string, ConditionsController.getStateFromString(string3));
                } else if (n == 0) {
                    this.newCondition = new VarCondition(string, ConditionsController.getStateFromString(string3), Integer.parseInt(string4));
                } else if (n == 2) {
                    this.newCondition = new GlobalStateCondition(string, ConditionsController.getStateFromString(string3));
                }
            } else {
                VarCondition varCondition;
                this.newCondition = condition;
                if (!string.equals(this.newCondition.getId())) {
                    this.newCondition.setId(string);
                }
                if (!new Integer(ConditionsController.getStateFromString(string3)).equals(this.newCondition.getState())) {
                    this.newCondition.setState(new Integer(ConditionsController.getStateFromString(string3)));
                }
                if (this.newCondition.getType() == 0 && !(varCondition = (VarCondition)condition).getValue().equals(Integer.parseInt(string4))) {
                    varCondition.setValue(Integer.valueOf(Integer.parseInt(string4)));
                }
            }
            this.conditions.get(this.index1).remove(this.index2);
            this.conditions.get(this.index1).add(this.index2, this.newCondition);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean redoTool() {
        this.conditions.get(this.index1).remove(this.index2);
        this.conditions.get(this.index1).add(this.index2, this.newCondition);
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.conditions.get(this.index1).remove(this.index2);
        this.conditions.get(this.index1).add(this.index2, this.oldCondition);
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }
}

