/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DuplicateConditionTool
extends Tool {
    private Conditions conditions;
    private int index1;
    private int index2;
    private Condition duplicate;

    public DuplicateConditionTool(Conditions conditions, int n, int n2) {
        this.conditions = conditions;
        this.index1 = n;
        this.index2 = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        try {
            if (this.duplicate == null) {
                this.duplicate = (Condition)((Condition)this.conditions.get(this.index1).get(this.index2)).clone();
            }
            this.conditions.get(this.index1).add(this.index2 + 1, this.duplicate);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean redoTool() {
        return this.doTool();
    }

    @Override
    public boolean undoTool() {
        this.conditions.get(this.index1).remove(this.index2 + 1);
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }
}

