/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteConditionTool
extends Tool {
    private Conditions conditions;
    private int index1;
    private int index2;
    private List<Condition> blockRemoved;
    private Condition singleConditionRemoved;

    public DeleteConditionTool(Conditions conditions, int n, int n2) {
        this.conditions = conditions;
        this.index1 = n;
        this.index2 = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.conditions.get(this.index1).size() == 1) {
            this.blockRemoved = this.conditions.delete(this.index1);
        } else {
            this.singleConditionRemoved = (Condition)this.conditions.get(this.index1).remove(this.index2);
        }
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean redoTool() {
        return this.doTool();
    }

    @Override
    public boolean undoTool() {
        if (this.blockRemoved != null) {
            this.conditions.add(this.index1, this.blockRemoved);
        } else if (this.singleConditionRemoved != null) {
            this.conditions.get(this.index1).add(this.index2, this.singleConditionRemoved);
        }
        Controller.getInstance().updateVarFlagSummary();
        Controller.getInstance().updatePanel();
        return true;
    }
}

