/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ClearConditionsTool
extends Tool {
    Conditions conditions;
    Conditions conditionsOld;

    public ClearConditionsTool(Conditions conditions) {
        try {
            this.conditionsOld = (Conditions)conditions.clone();
            this.conditions = conditions;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.conditions != null) {
            this.conditions.getConditionsList().clear();
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        return this.doTool();
    }

    @Override
    public boolean undoTool() {
        try {
            if (this.conditionsOld == null) {
                return false;
            }
            this.conditions = (Conditions)this.conditionsOld.clone();
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return false;
        }
        return true;
    }
}

