/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.conditions;

import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.FlagCondition;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalStateCondition;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class AddConditionTool
extends Tool {
    private Conditions conditions;
    private int index1;
    private int index2;
    private String conditionType;
    private String conditionId;
    private String conditionState;
    private String value;
    private List<Condition> blockAdded;
    private Condition conditionAdded;
    private int indexAdded;

    public AddConditionTool(Conditions conditions, int n, int n2, String string, String string2, String string3, String string4) {
        this.conditions = conditions;
        this.index1 = n;
        this.index2 = n2;
        this.conditionType = string;
        this.conditionId = string2;
        this.conditionState = string3;
        this.value = string4;
        this.blockAdded = null;
        this.conditionAdded = null;
        this.indexAdded = -1;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        FlagCondition flagCondition = null;
        int n = ConditionsController.getTypeFromString(this.conditionType);
        if (n == 1) {
            flagCondition = new FlagCondition(this.conditionId, ConditionsController.getStateFromString(this.conditionState));
        } else if (n == 0) {
            flagCondition = new VarCondition(this.conditionId, ConditionsController.getStateFromString(this.conditionState), Integer.parseInt(this.value));
        } else if (n == 2) {
            flagCondition = new GlobalStateCondition(this.conditionId, ConditionsController.getStateFromString(this.conditionState));
        }
        if (flagCondition != null) {
            if (this.index1 < this.conditions.size()) {
                if (this.index2 == -1) {
                    ArrayList<Condition> arrayList = new ArrayList<Condition>();
                    arrayList.add((Condition)flagCondition);
                    this.conditions.add(this.index1, arrayList);
                    this.indexAdded = this.index1;
                    this.blockAdded = arrayList;
                } else {
                    List list = this.conditions.get(this.index1);
                    if (this.index2 < 0 || this.index2 > list.size()) {
                        return false;
                    }
                    if (this.index2 == this.conditions.size()) {
                        list.add(flagCondition);
                        this.indexAdded = list.indexOf(flagCondition);
                        this.conditionAdded = flagCondition;
                    } else {
                        this.indexAdded = this.index2;
                        this.conditionAdded = flagCondition;
                        list.add(this.index2, flagCondition);
                    }
                }
            } else {
                ArrayList<Condition> arrayList = new ArrayList<Condition>();
                arrayList.add((Condition)flagCondition);
                this.conditions.add(arrayList);
                this.indexAdded = this.conditions.size() - 1;
                this.blockAdded = arrayList;
            }
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.blockAdded != null) {
            this.conditions.add(this.indexAdded, this.blockAdded);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.conditionAdded != null) {
            this.conditions.get(this.index1).add(this.indexAdded, this.conditionAdded);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.blockAdded != null) {
            this.conditions.delete(this.indexAdded);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.conditionAdded != null) {
            this.conditions.get(this.index1).remove(this.indexAdded);
            Controller.getInstance().updateVarFlagSummary();
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }
}

