/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.Titled;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTitleTool
extends Tool {
    private Titled titled;
    private String title;
    private String oldTitle;
    private Controller controller;

    public ChangeTitleTool(Titled titled, String string) {
        this.titled = titled;
        this.title = string;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (!this.title.equals(this.titled.getTitle())) {
            this.oldTitle = this.titled.getTitle();
            this.titled.setTitle(this.title);
            this.controller.updateStructure();
            this.controller.updateChapterMenu();
            return true;
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "Change Chapter Title";
    }

    @Override
    public boolean redoTool() {
        this.titled.setTitle(this.title);
        this.controller.updateStructure();
        this.controller.updateChapterMenu();
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.titled.setTitle(this.oldTitle);
        this.controller.updateStructure();
        this.controller.updateChapterMenu();
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeTitleTool) {
            ChangeTitleTool changeTitleTool = (ChangeTitleTool)tool;
            if (changeTitleTool.titled == this.titled && changeTitleTool.oldTitle == this.title) {
                this.title = changeTitleTool.title;
                this.timeStamp = changeTitleTool.timeStamp;
                return true;
            }
        }
        return false;
    }
}

