/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.HasTargetId;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTargetIdTool
extends Tool {
    protected String id;
    protected String oldId;
    protected boolean updateTree;
    protected boolean reloadPanel;
    protected Controller controller;
    protected HasTargetId elementWithTargetId;

    public ChangeTargetIdTool(HasTargetId hasTargetId, String string) {
        this(hasTargetId, string, false, true);
    }

    public ChangeTargetIdTool(HasTargetId hasTargetId, String string, boolean bl, boolean bl2) {
        this.elementWithTargetId = hasTargetId;
        this.id = string;
        this.oldId = hasTargetId.getTargetId();
        this.updateTree = bl;
        this.reloadPanel = bl2;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.elementWithTargetId.getTargetId() == null || !this.elementWithTargetId.getTargetId().equals(this.id)) {
            this.elementWithTargetId.setTargetId(this.id);
            bl = true;
            if (this.updateTree) {
                this.controller.updateStructure();
            }
            if (this.reloadPanel) {
                this.controller.updatePanel();
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        return this.undoTool();
    }

    @Override
    public boolean undoTool() {
        this.elementWithTargetId.setTargetId(this.oldId);
        String string = this.oldId;
        this.oldId = this.id;
        this.id = string;
        if (this.updateTree) {
            this.controller.updateStructure();
        }
        if (this.reloadPanel) {
            this.controller.updatePanel();
        }
        return true;
    }
}

