/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.Named;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeNameTool
extends Tool {
    private Named named;
    private String name;
    private String oldName;
    private Controller controller;

    public ChangeNameTool(Named named, String string) {
        this.named = named;
        this.name = string;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (!this.name.equals(this.named.getName())) {
            this.oldName = this.named.getName();
            this.named.setName(this.name);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.named.setName(this.name);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.named.setName(this.oldName);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeNameTool) {
            ChangeNameTool changeNameTool = (ChangeNameTool)tool;
            if (changeNameTool.named == this.named && changeNameTool.oldName == this.name) {
                this.name = changeNameTool.name;
                this.timeStamp = changeNameTool.timeStamp;
                return true;
            }
        }
        return false;
    }
}

