/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.Documented;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeDocumentationTool
extends Tool {
    private Documented documented;
    private String documentation;
    private String oldDocumentation;
    private Controller controller;

    public ChangeDocumentationTool(Documented documented, String string) {
        this.documented = documented;
        this.documentation = string;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (!this.documentation.equals(this.documented.getDocumentation())) {
            this.oldDocumentation = this.documented.getDocumentation();
            this.documented.setDocumentation(this.documentation);
            return true;
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "change docuemntation";
    }

    @Override
    public boolean redoTool() {
        this.documented.setDocumentation(this.documentation);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.documented.setDocumentation(this.oldDocumentation);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeDocumentationTool) {
            ChangeDocumentationTool changeDocumentationTool = (ChangeDocumentationTool)tool;
            if (changeDocumentationTool.documented == this.documented && changeDocumentationTool.oldDocumentation == this.documentation) {
                this.documentation = changeDocumentationTool.documentation;
                this.timeStamp = changeDocumentationTool.timeStamp;
                return true;
            }
        }
        return false;
    }
}

