/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.Detailed;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeDetailedDescriptionTool
extends Tool {
    private Detailed detailed;
    private String description;
    private String oldDescription;
    private Controller controller;

    public ChangeDetailedDescriptionTool(Detailed detailed, String string) {
        this.detailed = detailed;
        this.description = string;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (!this.description.equals(this.detailed.getDetailedDescription())) {
            this.oldDescription = this.detailed.getDetailedDescription();
            this.detailed.setDetailedDescription(this.description);
            return true;
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "Change description";
    }

    @Override
    public boolean redoTool() {
        this.detailed.setDetailedDescription(this.description);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.detailed.setDetailedDescription(this.oldDescription);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeDetailedDescriptionTool) {
            ChangeDetailedDescriptionTool changeDetailedDescriptionTool = (ChangeDetailedDescriptionTool)tool;
            if (changeDetailedDescriptionTool.detailed == this.detailed && changeDetailedDescriptionTool.oldDescription == this.description) {
                this.description = changeDetailedDescriptionTool.description;
                this.timeStamp = changeDetailedDescriptionTool.timeStamp;
                return true;
            }
        }
        return false;
    }
}

