/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.commontext;

import es.eucm.eadventure.common.data.Described;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeDescriptionTool
extends Tool {
    private Described described;
    private String description;
    private String oldDescription;
    private Controller controller;

    public ChangeDescriptionTool(Described described, String string) {
        this.described = described;
        this.description = string;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (!this.description.equals(this.described.getDescription())) {
            this.oldDescription = this.described.getDescription();
            this.described.setDescription(this.description);
            return true;
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "Change description";
    }

    @Override
    public boolean redoTool() {
        this.described.setDescription(this.description);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.described.setDescription(this.oldDescription);
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeDescriptionTool) {
            ChangeDescriptionTool changeDescriptionTool = (ChangeDescriptionTool)tool;
            if (changeDescriptionTool.described == this.described && changeDescriptionTool.oldDescription == this.description) {
                this.description = changeDescriptionTool.description;
                this.timeStamp = changeDescriptionTool.timeStamp;
                return true;
            }
        }
        return false;
    }
}

