/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class SetNoSelectedProfileTool
extends Tool {
    public static final int MODE_ADAPTATION = 41;
    public static final int MODE_ASSESSMENT = 40;
    public static final int MODE_UNKNOWN = -1;
    protected Chapter chapter;
    protected int mode;
    protected Controller controller;
    protected String oldValue;
    protected String newValue;

    public SetNoSelectedProfileTool(Chapter chapter, int n) {
        this.chapter = chapter;
        this.mode = n;
        this.controller = Controller.getInstance();
        this.newValue = "";
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.mode == 40) {
            this.oldValue = this.chapter.getAssessmentName();
        } else if (this.mode == 41) {
            this.oldValue = this.chapter.getAdaptationName();
        }
        if (this.oldValue == null) {
            this.setData(this.newValue);
        } else if (!this.oldValue.equals(this.newValue)) {
            this.setData(this.newValue);
            bl = true;
        }
        this.controller.updateVarFlagSummary();
        return bl;
    }

    private void setData(String string) {
        if (this.mode == 40) {
            this.chapter.setAssessmentName(string);
        } else if (this.mode == 41) {
            this.chapter.setAdaptationName(string);
        }
    }

    @Override
    public boolean redoTool() {
        this.setData(this.newValue);
        this.controller.updateVarFlagSummary();
        this.controller.reloadPanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.setData(this.oldValue);
        this.controller.updateVarFlagSummary();
        this.controller.reloadPanel();
        return true;
    }
}

