/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class MoveChapterTool
extends Tool {
    public static final int MODE_UP = 0;
    public static final int MODE_DOWN = 1;
    private ChapterListDataControl chaptersController;
    private Controller controller;
    private int mode;
    private int index;

    public MoveChapterTool(int n, ChapterListDataControl chapterListDataControl) {
        this.mode = n;
        this.chaptersController = chapterListDataControl;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        this.index = this.chaptersController.getSelectedChapter();
        if (this.mode == 0) {
            bl = this.moveChapterUp(this.index);
        } else if (this.mode == 1) {
            bl = this.moveChapterDown(this.index);
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            bl = this.moveChapterUp(this.index);
        } else if (this.mode == 1) {
            bl = this.moveChapterDown(this.index);
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = false;
        if (this.mode == 0) {
            bl = this.moveChapterDown(this.index - 1);
        } else if (this.mode == 1) {
            bl = this.moveChapterUp(this.index + 1);
        }
        return bl;
    }

    public boolean moveChapterUp(int n) {
        boolean bl = false;
        bl = this.chaptersController.moveChapterUp(n);
        if (bl) {
            this.controller.reloadData();
        }
        return bl;
    }

    public boolean moveChapterDown(int n) {
        boolean bl = false;
        bl = this.chaptersController.moveChapterDown(n);
        if (bl) {
            this.controller.reloadData();
        }
        return bl;
    }
}

