/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.common.auxiliar.AllElementsWithAssets;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.ImageLoaderFactory;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.common.loader.InputStreamCreator;
import es.eucm.eadventure.common.loader.Loader;
import es.eucm.eadventure.common.loader.parsers.ChapterHandler;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.EditorImageLoader;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.control.writer.AnimationWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportChapterTool
extends Tool {
    private Controller controller = Controller.getInstance();
    private ChapterListDataControl chaptersController;
    private int index;
    private HashMap<String, String> resourcesAdded;
    private int numberFilesChanged;
    private static final InputStreamCreator isCreator = new InputStreamCreator(){

        public InputStream buildInputStream(String string) {
            try {
                return new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }

        public URL buildURL(String string) {
            try {
                return new es.eucm.eadventure.common.auxiliar.File(string).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
        }

        public String[] listNames(String string) {
            return null;
        }
    };

    public ImportChapterTool(ChapterListDataControl chapterListDataControl) {
        this.chaptersController = chapterListDataControl;
        this.resourcesAdded = new HashMap();
        this.numberFilesChanged = 0;
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        File file = this.controller.selectXMLChapterFile();
        if (file != null && this.controller.showStrictConfirmDialog(TC.get((String)"ImportChapter.Notice.Title"), TC.get((String)"ImportChapter.Notice.Message"))) {
            this.controller.showLoadingScreen(TC.get((String)"LoadingScreen.ImportChapter.Message"));
            Chapter chapter = this.parseChapter(file);
            if (chapter != null) {
                if (AllElementsWithAssets.getAllAssets().size() > 0) {
                    this.getAllFiles(file);
                    chapter.setTitle(TC.get((String)"ImportChapter.ChapterDefault.Title"));
                    this.chaptersController.addChapterDataControl(chapter);
                    this.index = this.chaptersController.getSelectedChapter();
                    this.controller.reloadData();
                    this.controller.hideLoadingScreen();
                    if (this.numberFilesChanged > 0) {
                        this.controller.showInformationDialog(TC.get((String)"ImportChapter.ModifyFilesMessage.Title"), TC.get((String)"ImportChapter.ModifyFilesMessage.Message", (String)Integer.toString(this.numberFilesChanged)));
                    }
                    this.controller.showInformationDialog(TC.get((String)"ImportChapter.ImportationOK.Title"), TC.get((String)"ImportChapter.ImportationOK.Message"));
                    return true;
                }
                this.controller.hideLoadingScreen();
                this.controller.showInformationDialog(TC.get((String)"ImportChapter.BadFile.Title"), TC.get((String)"ImportChapter.BadFile.Message"));
                return false;
            }
            this.controller.hideLoadingScreen();
            this.controller.showInformationDialog(TC.get((String)"ImportChapter.UnknowProblems.Title"), TC.get((String)"ImportChapter.UnknowProblems.Message"));
            return false;
        }
        return false;
    }

    private Chapter parseChapter(File file) {
        Chapter chapter = new Chapter();
        if (file != null && file.exists()) {
            try {
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                if (fileInputStream != null) {
                    AllElementsWithAssets.resetAllAssets();
                    AllElementsWithAssets.setStorePath((boolean)true);
                    ChapterHandler chapterHandler = new ChapterHandler(isCreator, chapter);
                    Loader.getFactory().setValidating(false);
                    SAXParser sAXParser = Loader.getFactory().newSAXParser();
                    sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)chapterHandler);
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.getStackTrace();
                this.controller.showInformationDialog(TC.get((String)"ImportChapter.ProblemsParsing.Title"), TC.get((String)"ImportChapter.ProblemsParsing.Message"));
                chapter = null;
            }
            catch (SAXException sAXException) {
                sAXException.getStackTrace();
                this.controller.showInformationDialog(TC.get((String)"ImportChapter.ProblemsParsing.Title"), TC.get((String)"ImportChapter.ProblemsParsing.Message"));
                chapter = null;
            }
            catch (IOException iOException) {
                iOException.getStackTrace();
                this.controller.showInformationDialog(TC.get((String)"ImportChapter.ProblemsParsing.Title"), TC.get((String)"ImportChapter.ProblemsParsing.Message"));
                chapter = null;
            }
        }
        return chapter;
    }

    private void getAllFiles(File file) {
        String string = file.getAbsolutePath().substring(0, file.getAbsolutePath().indexOf(file.getName()));
        String string2 = null;
        String string3 = null;
        String string4 = this.controller.getProjectFolder();
        for (Object e : AllElementsWithAssets.getAllAssets()) {
            if (e instanceof HashMap) {
                for (Map.Entry entry : ((HashMap)e).entrySet()) {
                    string3 = this.manageResourcesAssets((String)entry.getValue(), string4, string);
                    entry.setValue(string3);
                }
                continue;
            }
            if (e instanceof ConversationLine) {
                string2 = ((ConversationLine)e).getAudioPath();
                string3 = this.copyFile(string4, string2, string);
                ((ConversationLine)e).setAudioPath(string3);
                continue;
            }
            if (e instanceof AbstractEffect) {
                if (((AbstractEffect)e).getType() == 8) {
                    string2 = ((PlaySoundEffect)e).getPath();
                    string3 = this.copyFile(string4, string2, string);
                    ((PlaySoundEffect)e).setPath(string3);
                    continue;
                }
                if (((AbstractEffect)e).getType() != 9) continue;
                string2 = ((PlayAnimationEffect)e).getPath();
                string3 = this.copyFile(string4, string2, string);
                ((PlayAnimationEffect)e).setPath(string3);
                continue;
            }
            if (e instanceof BookPage) {
                string2 = ((BookPage)e).getUri();
                string3 = this.copyFile(string4, string2, string);
                Object object2 = "";
                String string5 = string2.substring(0, string2.lastIndexOf("."));
                if (((BookPage)e).getType() == 1) {
                    if (new es.eucm.eadventure.common.auxiliar.File(string + string5 + "_files").exists()) {
                        object2 = "_files";
                    } else if (new es.eucm.eadventure.common.auxiliar.File(string + string5 + "_archivos").exists()) {
                        object2 = "_archivos";
                    } else {
                        this.controller.showInformationDialog(TC.get((String)"ImportChapter.NoFolderForHTMLImages.Title"), TC.get((String)"ImportChapter.NoFolderForHTMLImages.Message", (String)(string + string2)));
                    }
                    if (!((String)object2).equals("")) {
                        es.eucm.eadventure.common.auxiliar.File file2 = new es.eucm.eadventure.common.auxiliar.File(string4 + "/" + string5 + (String)object2);
                        es.eucm.eadventure.common.auxiliar.File file3 = new es.eucm.eadventure.common.auxiliar.File(string + "/" + string5 + (String)object2);
                        if (!file2.exists()) {
                            file2.mkdir();
                        }
                        String[] stringArray = file3.list();
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (es.eucm.eadventure.common.auxiliar.File.copyTo((File)new es.eucm.eadventure.common.auxiliar.File(file3, stringArray[i]), (File)new es.eucm.eadventure.common.auxiliar.File(file2, stringArray[i]))) continue;
                            System.out.println("something wrong happens");
                        }
                    }
                }
                ((BookPage)e).setUri(string3);
                continue;
            }
            if (!(e instanceof BookParagraph)) continue;
            string2 = ((BookParagraph)e).getContent();
            string3 = this.copyFile(string4, string2, string);
            ((BookParagraph)e).setContent(string3);
        }
        AllElementsWithAssets.setStorePath((boolean)false);
        AllElementsWithAssets.resetAllAssets();
    }

    private String manageResourcesAssets(String string, String string2, String string3) {
        String string4 = "";
        String[] stringArray = string.split("/");
        String string5 = stringArray[stringArray.length - 1];
        if (string.endsWith(".eaa")) {
            Animation animation = Loader.loadAnimation((InputStreamCreator)isCreator, (String)(string3 + string), (ImageLoaderFactory)new EditorImageLoader());
            for (Frame frame : animation.getFrames()) {
                if (frame.getUri() != null && !frame.getUri().equals("")) {
                    frame.setUri(this.copyFile(string2, frame.getUri(), string3));
                }
                if (frame.getSoundUri() == null || frame.getSoundUri() == "") continue;
                frame.setSoundUri(this.copyFile(string2, frame.getSoundUri(), string3));
            }
            string4 = this.copyFile(string2, string, string3);
            AnimationWriter.writeAnimation(string4, animation);
        } else if (!string5.contains(".")) {
            String string6 = string.substring(0, string.indexOf(string5));
            String string7 = string3 + string6 + string5;
            String string8 = "";
            if (new es.eucm.eadventure.common.auxiliar.File(string7 + "_01.jpg").exists() || new es.eucm.eadventure.common.auxiliar.File(string7 + ".jpg").exists()) {
                string8 = ".jpg";
            } else if (new es.eucm.eadventure.common.auxiliar.File(string7 + "_01.png").exists() || new es.eucm.eadventure.common.auxiliar.File(string7 + ".png").exists()) {
                string8 = ".png";
            }
            int n = 2;
            String string9 = string7 + "_01" + string8;
            if (new es.eucm.eadventure.common.auxiliar.File(string9).exists()) {
                boolean bl = true;
                while (bl) {
                    string4 = this.copyFile(string2, string6 + string9.substring(string9.indexOf(string5), string9.length()), string3);
                    string9 = n < 9 ? string7 + "_0" + n + string8 : string7 + "_" + n + string8;
                    ++n;
                    bl = new es.eucm.eadventure.common.auxiliar.File(string9).exists();
                }
            } else {
                string4 = this.copyFile(string2, string6 + string9.substring(string9.indexOf(string5), string9.length()), string3);
            }
            string4 = string4.substring(0, string4.lastIndexOf("_"));
        } else {
            string4 = this.copyFile(string2, string, string3);
        }
        return string4;
    }

    private String copyFile(String string, String string2, String string3) {
        if (this.resourcesAdded.get(string2) == null) {
            String string4 = string + "\\" + string2;
            es.eucm.eadventure.common.auxiliar.File file = new es.eucm.eadventure.common.auxiliar.File(string4);
            String string5 = string2.substring(string2.lastIndexOf("/"));
            String string6 = string2.substring(0, string2.indexOf(string5));
            String string7 = string + "/" + string6;
            if (!string2.contains("assets/special") || !file.exists()) {
                int n = 0;
                boolean bl = true;
                String string8 = "";
                boolean bl2 = false;
                if (Character.isDigit(string5.charAt(string5.lastIndexOf("_") + 1)) && Character.isDigit(string5.charAt(string5.lastIndexOf("_") + 2)) && string5.charAt(string5.lastIndexOf("_") + 3) == '.') {
                    string8 = string5.substring(string5.lastIndexOf("_"), string5.lastIndexOf("."));
                    bl2 = true;
                }
                while (file.exists()) {
                    String[] stringArray;
                    if (string5.contains("impEad")) {
                        stringArray = string5.split("impEad");
                        stringArray[1] = stringArray[1].substring(stringArray[1].lastIndexOf("."));
                        string5 = stringArray[0] + "impEad" + n + string8 + stringArray[1];
                    } else {
                        stringArray = string5.split("\\.");
                        if (bl2) {
                            stringArray[0] = stringArray[0].substring(0, stringArray[0].lastIndexOf("_"));
                        }
                        string5 = stringArray[0] + "_impEad" + n + string8 + "." + stringArray[1];
                    }
                    if (bl) {
                        ++this.numberFilesChanged;
                    }
                    bl = false;
                    string4 = string7 + string5;
                    file = new es.eucm.eadventure.common.auxiliar.File(string4);
                    ++n;
                }
                if (!es.eucm.eadventure.common.auxiliar.File.copyTo((File)new es.eucm.eadventure.common.auxiliar.File(string3 + string2), (File)new es.eucm.eadventure.common.auxiliar.File(string4))) {
                    this.controller.showInformationDialog(TC.get((String)"ImportChapter.ProblemsCopying.Title"), TC.get((String)"ImportChapter.ProblemsCopying.Message", (String)(string3 + string2)));
                }
            }
            this.resourcesAdded.put(string2, string6 + string5);
            return string6 + string5;
        }
        return this.resourcesAdded.get(string2);
    }

    @Override
    public boolean redoTool() {
        return false;
    }

    @Override
    public boolean undoTool() {
        boolean bl = this.chaptersController.removeChapterDataControl(this.index) != null;
        this.controller.reloadData();
        return bl;
    }
}

