/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteChapterTool
extends Tool {
    private Controller controller;
    private ChapterListDataControl chaptersController;
    private Chapter chapterRemoved;
    private int index;

    public DeleteChapterTool(ChapterListDataControl chapterListDataControl) {
        this.chaptersController = chapterListDataControl;
        this.controller = Controller.getInstance();
        this.doesClone(true);
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.chaptersController.getChaptersCount() > 1) {
            if (this.controller.showStrictConfirmDialog(TC.get((String)"Operation.DeleteChapterTitle"), TC.get((String)"Operation.DeleteChapterMessage"))) {
                this.index = this.chaptersController.getSelectedChapter();
                this.chapterRemoved = (Chapter)this.chaptersController.removeChapterDataControl().getContent();
                bl = true;
                this.controller.reloadData();
            }
        } else {
            this.controller.showErrorDialog(TC.get((String)"Operation.DeleteChapterTitle"), TC.get((String)"Operation.DeleteChapterErrorLastChapter"));
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        this.chaptersController.removeChapterDataControl(this.index);
        this.controller.reloadData();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.chaptersController.addChapterDataControl(this.index, this.chapterRemoved);
        this.controller.reloadData();
        return true;
    }
}

