/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeSelectedProfileTool
extends Tool {
    public static final int MODE_ADAPTATION = 41;
    public static final int MODE_ASSESSMENT = 40;
    public static final int MODE_DELETE_ASSESS = 0;
    public static final int MODE_DELETE_ADAPT = 1;
    public static final int MODE_UNKNOWN = -1;
    protected Chapter chapter;
    protected int mode;
    protected Controller controller;
    protected String oldValue;
    protected String newValue;

    public ChangeSelectedProfileTool(Chapter chapter, int n, String string) {
        this.chapter = chapter;
        this.mode = n;
        this.newValue = string;
        this.controller = Controller.getInstance();
    }

    public ChangeSelectedProfileTool(Chapter chapter, int n) {
        this.chapter = chapter;
        this.mode = n;
        this.newValue = null;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        Object[] objectArray = new String[1];
        if (this.mode == 40) {
            objectArray = this.chapter.getAssessmentProfilesNames();
        } else if (this.mode == 41) {
            objectArray = this.chapter.getAdaptationProfilesNames();
        }
        if (this.mode == 0) {
            this.oldValue = this.chapter.getAssessmentName();
            this.chapter.setAssessmentName("");
        } else if (this.mode == 1) {
            this.oldValue = this.chapter.getAdaptationName();
            this.chapter.setAdaptationName("");
        } else if (objectArray.length == 0) {
            if (this.mode == 40) {
                this.controller.showErrorDialog(TC.get((String)"Resources.EditAsset"), TC.get((String)"Operation.AssignAssessmentProfile"));
            } else if (this.mode == 41) {
                this.controller.showErrorDialog(TC.get((String)"Resources.EditAsset"), TC.get((String)"Operation.AssignAdaptationProfile"));
            }
        } else if (this.newValue == null) {
            String string = this.controller.showInputDialog(TC.get((String)"Resources.EditAsset"), TC.get((String)"Resources.EditAssetMessage"), objectArray);
            if (this.mode == 40) {
                this.oldValue = this.chapter.getAssessmentName();
            } else if (this.mode == 41) {
                this.oldValue = this.chapter.getAdaptationName();
            }
            if (string != null) {
                int n = -1;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((String)objectArray[i]).equals(string)) continue;
                    n = i;
                }
                if (this.mode == 40) {
                    this.chapter.setAssessmentName((String)objectArray[n]);
                } else if (this.mode == 41) {
                    this.chapter.setAdaptationName((String)objectArray[n]);
                }
                this.newValue = objectArray[n];
                bl = true;
            }
        } else {
            if (this.mode == 40) {
                this.oldValue = this.chapter.getAssessmentName();
                this.chapter.setAssessmentName(this.newValue);
            } else if (this.mode == 41) {
                this.oldValue = this.chapter.getAdaptationName();
                this.chapter.setAdaptationName(this.newValue);
            }
            bl = true;
        }
        this.controller.updateVarFlagSummary();
        return bl;
    }

    @Override
    public boolean redoTool() {
        if (this.mode == 40) {
            this.chapter.setAssessmentName(this.newValue);
        } else if (this.mode == 41) {
            this.chapter.setAdaptationName(this.newValue);
        } else if (this.mode == 0) {
            this.chapter.setAssessmentName("");
        } else if (this.mode == 1) {
            this.chapter.setAdaptationName("");
        }
        this.controller.reloadPanel();
        this.controller.updateVarFlagSummary();
        return true;
    }

    @Override
    public boolean undoTool() {
        if (this.mode == 40 || this.mode == 0) {
            this.chapter.setAssessmentName(this.oldValue);
        } else if (this.mode == 41 || this.mode == 1) {
            this.chapter.setAdaptationName(this.oldValue);
        }
        this.controller.updateVarFlagSummary();
        this.controller.reloadPanel();
        return true;
    }
}

