/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.chapters;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddChapterTool
extends Tool {
    private Controller controller;
    private ChapterListDataControl chaptersController;
    private Chapter newChapter;
    private int index;
    private String chapterTitle;

    public AddChapterTool(ChapterListDataControl chapterListDataControl) {
        this.chaptersController = chapterListDataControl;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.chapterTitle = this.controller.showInputDialog(TC.get((String)"Operation.AddChapterTitle"), TC.get((String)"Operation.AddChapterMessage"), TC.get((String)"Operation.AddChapterDefaultValue"));
        if (this.chapterTitle != null) {
            if (!this.chaptersController.exitsChapter(this.chapterTitle)) {
                this.newChapter = new Chapter(this.chapterTitle, TC.get((String)"DefaultValue.SceneId"));
                this.chaptersController.addChapterDataControl(this.newChapter);
                this.index = this.chaptersController.getSelectedChapter();
                this.controller.reloadData();
                return true;
            }
            this.controller.showErrorDialog(TC.get((String)"Operation.CreateAdaptationFile.FileName.ExistValue.Title"), TC.get((String)"Operation.NewChapter.ExistingName"));
            return false;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.newChapter = new Chapter(this.chapterTitle, TC.get((String)"DefaultValue.SceneId"));
        this.chaptersController.addChapterDataControl(this.newChapter);
        this.index = this.chaptersController.getSelectedChapter();
        this.controller.reloadData();
        return true;
    }

    @Override
    public boolean undoTool() {
        boolean bl = this.chaptersController.removeChapterDataControl(this.index) != null;
        this.controller.reloadData();
        return bl;
    }
}

