/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectExitCursorPathTool
extends SelectResourceTool {
    protected static final String CURSOR_STR = "cursor";
    protected ExitLook exitLook;

    protected static AssetInformation[] createAssetInfoArray() {
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", CURSOR_STR, true, 6, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(ExitLook exitLook) {
        Resources resources = new Resources();
        resources.addAsset(CURSOR_STR, exitLook.getCursorPath());
        return resources;
    }

    public SelectExitCursorPathTool(ExitLook exitLook) throws CloneNotSupportedException {
        super(SelectExitCursorPathTool.createResources(exitLook), SelectExitCursorPathTool.createAssetInfoArray(), 4, 0);
        this.exitLook = exitLook;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(CURSOR_STR));
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl = super.redoTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(CURSOR_STR));
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean doTool() {
        boolean bl = super.doTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(CURSOR_STR));
        return true;
    }
}

