/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectCursorPathTool
extends SelectResourceTool {
    protected AdventureData adventureData;
    protected int t;
    protected String type;
    protected boolean added;

    protected static AssetInformation[] createAssetInfoArray(int n) {
        String string = DescriptorData.getCursorTypeString((int)n);
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", string, true, 6, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(AdventureData adventureData, int n) {
        String string = DescriptorData.getCursorTypeString((int)n);
        Resources resources = new Resources();
        boolean bl = false;
        for (int i = 0; i < adventureData.getCursors().size(); ++i) {
            if (!((CustomCursor)adventureData.getCursors().get(i)).getType().equals(string) || ((CustomCursor)adventureData.getCursors().get(i)).getPath() == null) continue;
            resources.addAsset(string, ((CustomCursor)adventureData.getCursors().get(i)).getPath());
            bl = true;
            break;
        }
        if (!bl) {
            resources.addAsset(string, null);
        }
        return resources;
    }

    public SelectCursorPathTool(AdventureData adventureData, int n) throws CloneNotSupportedException {
        super(SelectCursorPathTool.createResources(adventureData, n), SelectCursorPathTool.createAssetInfoArray(n), 230, 0);
        this.adventureData = adventureData;
        this.t = n;
        this.type = DescriptorData.getCursorTypeString((int)n);
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getCursors().size(); ++i) {
            if (!((CustomCursor)this.adventureData.getCursors().get(i)).getType().equals(this.type)) continue;
            if (this.added) {
                this.adventureData.getCursors().remove(i);
                break;
            }
            ((CustomCursor)this.adventureData.getCursors().get(i)).setPath(this.resources.getAssetPath(this.type));
            break;
        }
        this.controller.updatePanel();
        this.controller.dataModified();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl = super.redoTool();
        if (this.added) {
            this.adventureData.addCursor(this.type, "");
        }
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getCursors().size(); ++i) {
            if (!((CustomCursor)this.adventureData.getCursors().get(i)).getType().equals(this.type)) continue;
            ((CustomCursor)this.adventureData.getCursors().get(i)).setPath(this.resources.getAssetPath(this.type));
        }
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean doTool() {
        if (this.resources.getAssetPath(this.type) == null) {
            this.adventureData.addCursor(this.type, "");
            this.added = true;
        } else {
            this.added = false;
        }
        boolean bl = super.doTool();
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getCursors().size(); ++i) {
            if (!((CustomCursor)this.adventureData.getCursors().get(i)).getType().equals(this.type)) continue;
            ((CustomCursor)this.adventureData.getCursors().get(i)).setPath(this.resources.getAssetPath(this.type));
        }
        return true;
    }
}

